% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.VSURF.R
\name{summary.VSURF}
\alias{summary.VSURF}
\title{Summary of VSURF results}
\usage{
\method{summary}{VSURF}(object, ...)
}
\arguments{
\item{object}{An object of class \code{VSURF}, which is the result of the
\code{\link{VSURF}} function.}

\item{\dots}{Not used.}
}
\description{
This function displays a summary of VSURF results
}
\details{
This function prints the total computation time of VSURF.  It also gives the
number of selected variables (and the computation time) at each step of
VSURF. In addition, it gives the number of cores and the type of cluster
if the parallel version of VSURF was used.
}
\examples{

\dontrun{
data(iris)
iris.vsurf <- VSURF(iris[,1:4], iris[,5], ntree = 100, nfor.thres = 20,
                    nfor.interp = 10, nfor.pred = 10)
summary(iris.vsurf)

# A more interesting example with toys data (see \code{\link{toys}})
# (a few minutes to execute)
data(toys)
toys.vsurf <- VSURF(toys$x, toys$y)
summary(toys.vsurf)}

}
\references{
Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2010),
\emph{Variable selection using random forests}, Pattern Recognition Letters
31(14), 2225-2236

Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2015),
\emph{VSURF: An R Package for Variable Selection Using Random Forests},
The R Journal 7(2):19-33
}
\seealso{
\code{\link{VSURF}}, \code{\link{plot.VSURF}}
}
\author{
Robin Genuer, Jean-Michel Poggi and Christine Tuleau-Malot
}
