% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelselection_lm.R
\name{modelselect.lm}
\alias{modelselect.lm}
\title{Title: Variable selection for linear models}
\usage{
modelselect.lm(
  formula,
  data,
  GA_var = 16,
  maxiterations = 2000,
  runs_til_stop = 1000,
  monitor = TRUE,
  popSize = 100,
  verbose = TRUE
)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.
A typical model has the form \code{response ~ terms} where response is the (numeric) \code{response} vector and terms is a series of terms which specifies a linear predictor for \code{response}.
A terms specification of the form \code{first + second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed.
A specification of the form \code{first:second} indicates the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}.
The specification \code{first*second} indicates the cross of \code{first} and \code{second.} This is the same as \code{first + second + first:second}.}

\item{data}{an data frame containing the variables in the model.}

\item{GA_var}{if the number of variables is smaller than \code{GA_var}, then do exhaustive model search, otherwise use genetic algorithm to do stochastic model search.}

\item{maxiterations}{the maximum number of iterations to run before the GA search is halted.}

\item{runs_til_stop}{the number of consecutive generations without any improvement in the best fitness value before the GA is stopped.}

\item{monitor}{a logical defaulting to TRUE showing the evolution of the search. If monitor = FALSE, any output is suppressed.}

\item{popSize}{the population size.}

\item{verbose}{Logical; if TRUE, print a brief summary of results.}
}
\value{
\code{modelselect.lm} returns a list containing the following components:

\describe{
\item{\code{models}}{A data frame of candidate models' BIC and posterior probabilities, sorted by decreasing posterior probability}
\item{\code{variables}}{A data frame of candidate variables' posterior inclusion probabilities}
\item{\code{data}}{The data with variables in the formula.}
}

The function \code{lm.best} is used to obtain the linear fitting to the best model by posterior probability or by controlling variables' posterior inclusion probabilities.
}
\description{
Description: use BIC to do variable selection.
}
