% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphrag.R
\name{KnowledgeGraph}
\alias{KnowledgeGraph}
\title{Knowledge Graph}
\description{
Graph storage for entities and relationships
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Graph name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KnowledgeGraph-new}{\code{KnowledgeGraph$new()}}
\item \href{#method-KnowledgeGraph-add_entity}{\code{KnowledgeGraph$add_entity()}}
\item \href{#method-KnowledgeGraph-add_relationship}{\code{KnowledgeGraph$add_relationship()}}
\item \href{#method-KnowledgeGraph-get_entity}{\code{KnowledgeGraph$get_entity()}}
\item \href{#method-KnowledgeGraph-get_all_entities}{\code{KnowledgeGraph$get_all_entities()}}
\item \href{#method-KnowledgeGraph-get_all_relationships}{\code{KnowledgeGraph$get_all_relationships()}}
\item \href{#method-KnowledgeGraph-get_neighbors}{\code{KnowledgeGraph$get_neighbors()}}
\item \href{#method-KnowledgeGraph-traverse}{\code{KnowledgeGraph$traverse()}}
\item \href{#method-KnowledgeGraph-entity_count}{\code{KnowledgeGraph$entity_count()}}
\item \href{#method-KnowledgeGraph-relationship_count}{\code{KnowledgeGraph$relationship_count()}}
\item \href{#method-KnowledgeGraph-search_entities}{\code{KnowledgeGraph$search_entities()}}
\item \href{#method-KnowledgeGraph-clone}{\code{KnowledgeGraph$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-new"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-new}{}}}
\subsection{Method \code{new()}}{
Create a new KnowledgeGraph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$new(name = "default")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Graph name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-add_entity"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-add_entity}{}}}
\subsection{Method \code{add_entity()}}{
Add an entity
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$add_entity(entity)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entity}}{Entity object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-add_relationship"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-add_relationship}{}}}
\subsection{Method \code{add_relationship()}}{
Add a relationship
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$add_relationship(relationship)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relationship}}{Relationship object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-get_entity"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-get_entity}{}}}
\subsection{Method \code{get_entity()}}{
Get entity by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$get_entity(entity_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entity_id}}{Entity ID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Entity or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-get_all_entities"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-get_all_entities}{}}}
\subsection{Method \code{get_all_entities()}}{
Get all entities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$get_all_entities()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of Entity objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-get_all_relationships"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-get_all_relationships}{}}}
\subsection{Method \code{get_all_relationships()}}{
Get all relationships
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$get_all_relationships()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of Relationship objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-get_neighbors"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-get_neighbors}{}}}
\subsection{Method \code{get_neighbors()}}{
Get neighbors of an entity
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$get_neighbors(entity_id, direction = "both")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entity_id}}{Entity ID}

\item{\code{direction}}{"out", "in", or "both"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of Entity objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-traverse"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-traverse}{}}}
\subsection{Method \code{traverse()}}{
Traverse graph from seed entities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$traverse(seed_ids, max_depth = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seed_ids}}{Starting entity IDs}

\item{\code{max_depth}}{Maximum depth}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
SubGraph object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-entity_count"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-entity_count}{}}}
\subsection{Method \code{entity_count()}}{
Get entity count
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$entity_count()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-relationship_count"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-relationship_count}{}}}
\subsection{Method \code{relationship_count()}}{
Get relationship count
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$relationship_count()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-search_entities"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-search_entities}{}}}
\subsection{Method \code{search_entities()}}{
Search entities by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$search_entities(query, limit = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query string}

\item{\code{limit}}{Max results}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of Entity objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnowledgeGraph-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KnowledgeGraph-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnowledgeGraph$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
