% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_vectors.R
\name{download_word_vectors}
\alias{download_word_vectors}
\title{Download pre-trained word vectors}
\usage{
download_word_vectors(model = "glove-100", dest_dir = NULL, overwrite = FALSE)
}
\arguments{
\item{model}{Model to download: "glove-50", "glove-100", "glove-200", "glove-300",
"glove-twitter-25", "glove-twitter-50", "glove-twitter-100", "glove-twitter-200"}

\item{dest_dir}{Destination directory (default: user cache)}

\item{overwrite}{Overwrite existing files}
}
\value{
Path to the downloaded vectors file
}
\description{
Downloads GloVe or fastText word vectors
}
\examples{
\dontrun{
# Download 100-dimensional GloVe vectors (~130MB)
path <- download_word_vectors("glove-100")

# Use with Vectrix
db <- Vectrix$new("docs", model = "glove", model_path = path)
}
}
