% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniTools.R
\name{reproduce_id}
\alias{reproduce_id}
\title{Reproduce ID}
\usage{
reproduce_id(data_matrix, metadata, metadata_type, id_match)
}
\arguments{
\item{data_matrix}{data.frame containing data_matrix}

\item{metadata}{data.frame containing samplemetadata or variablemetadata}

\item{metadata_type}{"sample" or "variable" depending on metadata content}

\item{id_match}{'id_match' element produced by stock_id}
}
\value{
a named \code{list} with two elements:
data_matrix: the processed data matrix with its original names and order
metadata: the processed metadata, with its original names and order.
}
\description{
reproduce_id
reproduce_id() reinjects original identifiers and original order into
final tables
}
\examples{
\donttest{

myDM <- data.frame(data = 1:6, a = 2:7, b = 3:8, c = 2:7, d = 3:8, e = 2:7)
myvM <- data.frame(variable = 1:6, x = 4:9, y = 2:7, z = 3:8)

A <- W4MRUtils::stock_id(myDM, myvM, "variable")
myDM <- A$dataMatrix
myvM <- A$Metadata
A <- A$id.match

## processing that may change order or requires specific identifiers format
## ...
datamatrix <- as.data.frame(myDM)
sample_metadata <- as.data.frame(myvM)

B <- W4MRUtils::reproduce_id(datamatrix, sample_metadata, "variable", A)
datamatrix <- B$dataMatrix
sample_metadata <- B$Metadata
}

}
\author{
M.Petera
}
