% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galaxy.R
\name{show_galaxy_header}
\alias{show_galaxy_header}
\title{show_galaxy_header - shows the header for glaxy tools}
\usage{
show_galaxy_header(
  tool_name,
  tool_version,
  args = NULL,
  logger = NULL,
  show_start_time = TRUE,
  show_sys = TRUE,
  show_parameters = TRUE
)
}
\arguments{
\item{tool_name}{a \code{character(1)} holding the
running tool's name.}

\item{tool_version}{a \code{character(1)} holding the
running tool's version.}

\item{args}{a \code{list(param="value")} - if provided, their are the
parameters shown in galaxy header and/or footer.}

\item{logger}{a \code{get_logger("name")} instance - if provided, the
galaxy footer if output from the logger.}

\item{show_start_time}{\itemize{
\item a logical telling whether to display
the start time or not.
}}

\item{show_sys}{\itemize{
\item a logical telling whether to display
the system variables or not.
}}

\item{show_parameters}{\itemize{
\item a logical telling whether to display
the parameters or not.
}}
}
\value{
\code{NULL}
}
\description{
This function prints the header to display in galaxy's tools logs
}
\examples{

show_galaxy_header("Tool Name", "1.2.0")
show_galaxy_header(
  tool_name = "Tool Name",
  tool_version = "1.2.0",
  logger = get_logger("Some Tool"),
  show_start_time = FALSE,
  show_sys = FALSE,
  show_parameters = FALSE
)

}
\seealso{
\link{run_galaxy_processing}
}
\author{
L.Pavot
}
