% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stopaste0}
\alias{stopaste0}
\title{stopaste0 - to paste string to a message and stop}
\usage{
stopaste0(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[base:paste]{base::paste0}}
  \describe{
    \item{\code{collapse}}{an optional character string to separate the results.  Not
    \code{\link[base]{NA_character_}}.  When \code{collapse} is a string,
    the result is always a string (\code{\link[base]{character}} of length 1).}
    \item{\code{recycle0}}{\code{\link[base]{logical}} indicating if zero-length
    character arguments should result in the zero-length
    \code{\link[base]{character}(0)}.  Note that when \code{collapse} is
    a string, \code{recycle0} does \emph{not} recycle to zero-length, but
    to \code{""}.}
  }}
}
\value{
\code{NULL}
}
\description{
stopaste calls paste0 of its parameters to build the error message
and stops with the given message
}
\examples{

tryCatch({
  file <- "/tmp/test"
  stopaste0("Error in file: ", file)
}, error = function(error) {
  print(error)
})

}
\author{
L.Pavot
}
