% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.WRI.R
\name{summary.WRI}
\alias{summary.WRI}
\title{Summary Function of Wasserstein Regression Model}
\usage{
\method{summary}{WRI}(object, ...)
}
\arguments{
\item{object}{an object returned by the \code{wass_regress} function}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list containing the following fields:
\item{call}{function call of the Wasserstein regression}
\item{r.square}{Wasserstein \eqn{R^2}, the Wasserstein coefficient of determination}
\item{global_wasserstein_F_stat}{Wasserstein global F test statistic from the Satterthwaite method}
\item{global_F_pvalue}{p value of global F test}
\item{global_wasserstein_F_df}{degrees of freedom of satterthwaite approximated sampling distribution used in global F test}
\item{partial_F_table}{Partial F test for individual effects}
}
\description{
Summary Function of Wasserstein Regression Model
}
\examples{
data(strokeCTdensity)
predictor = strokeCTdensity$predictors
dSup = strokeCTdensity$densitySupport
densityCurves = strokeCTdensity$densityCurve

res <- wass_regress(rightside_formula = ~., Xfit_df = predictor,
Ymat = densityCurves, Ytype = 'density', Sup = dSup)
summary(res)
}
