% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioavailability.R
\name{calculate_f}
\alias{calculate_f}
\title{Calculate bioavailability with pivoted output}
\usage{
calculate_f(res_nca, f_aucs)
}
\arguments{
\item{res_nca}{A list containing non-compartmental analysis (NCA) results,
including concentration and dose data.}

\item{f_aucs}{A character vector of the comparing AUC parameter/s including
the prefix f_ (e.g., \code{c("f_aucinf.obs", "f_auclast")}).}
}
\value{
A pivoted data frame with bioavailability calculations (\code{f_aucinf}, \code{f_auclast}, etc.)
for individual subjects where IV data is available. If IV data is missing for the subject,
the mean IV AUC for that group is used instead. Variables are assumed to be in \verb{\%} units.
}
\description{
This function calculates bioavailability (F) based on AUC (Area Under Curve) data
extracted from \code{res_nca}. It computes individual bioavailability
where IV and EX data are available for a subject. If IV data is missing, it estimates
bioavailability using the mean IV values for that grouping. The output is pivoted
such that each row represents all main results summarized for each profile in each
subject. Columns are assumed to be in \verb{\%} units even if not explicitly stated.
}
