% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamics.R
\name{dynamics}
\alias{dynamics}
\alias{update.dynamics}
\alias{is.dynamics}
\title{Create and update population dynamics objects}
\usage{
dynamics(matrix, ...)

\method{update}{dynamics}(object, ...)

is.dynamics(x)
}
\arguments{
\item{matrix}{a matrix of vital rates specifying transitions between
ages or stages. Specified in the format ntp1 = A %*% nt, where
A is the matrix and nt is the vector of abundances, so that values
in a given column and row denote a transition from that column
to that row}

\item{\dots}{additional objects used to define population dynamics.
Must be one or more of \code{\link{covariates}},
\code{\link{replicated_covariates}},
\code{\link{environmental_stochasticity}},
\code{\link{demographic_stochasticity}},
\code{\link{density_dependence}},
\code{\link{add_remove_pre}}, or
\code{\link{add_remove_post}}.
Note that \code{\link{density_dependence_n}} is equivalent to
\code{\link{add_remove_post}}.}

\item{object}{a \code{dynamics} object}

\item{x}{an object to pass to \code{is.dynamics}}
}
\value{
\code{dynamics} object containing a matrix population model
  and all associated processes
}
\description{
Define population dynamics from a matrix and additional
  objects that determine covariate effects, density dependence, and
  forms of stochasticity.
}
\details{
A call to \code{dynamics} defines an object of class
  \code{dynamics}, which can be used to simulate population
  trajectories with the \code{\link{simulate}} function. The \code{plot}
  function is supported and will generate a general life-cycle
  diagram based on the defined population dynamics.

A compiled \code{dynamics} object can be
  updated to change any of the included processes with
  the \code{update} function.
}
\examples{
# define a population
nclass <- 5
popmat <- matrix(0, nrow = nclass, ncol = nclass)
popmat[reproduction(popmat, dims = 4:5)] <- c(10, 20)
popmat[transition(popmat)] <- c(0.25, 0.3, 0.5, 0.65)

# define a dynamics object
dyn <- dynamics(popmat)

# and plot this
if (rlang::is_installed("DiagrammeR")) {
  plot(dyn)
}
}
