% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{exps}
\alias{exps}
\title{Calculate expected population size for a
  \code{\link{simulate}} object based on
  generic functions (ExPS)}
\usage{
exps(
  sims,
  subset = NULL,
  times = NULL,
  fun_within = mean,
  fun_among = mean,
  ...
)
}
\arguments{
\item{sims}{an object returned from \code{\link{simulate}}}

\item{subset}{\code{integer} vector denoting the population classes
to include in calculation of population abundance. Defaults to
all classes}

\item{times}{\code{integer} vector specifying generations to
include in calculation of extinction risk. Defaults to all
simulated generations}

\item{fun_within}{\code{function} used to summarise a single
trajectory. Must return a single value. Defaults to \code{mean}}

\item{fun_among}{\code{function} used to summarise over all
replicate trajectories. Defaults to \code{mean}. Alternatives
might include \code{median} or \code{min}}

\item{\dots}{additional arguments passed to \code{fun_within} and
\code{fun_among}. If these conflict, a wrapper function could
be used to define expected arguments for each function}
}
\value{
a single value representing the expected statistic applied
  to the population sizes generated with \code{\link{simulate}}
}
\description{
Calculate expected population size for a
  \code{\link{simulate}} object based on
  generic functions (ExPS)
}
\details{
Expected population size (ExPS) is a highly
  flexible generalisation of \code{\link{emps}} and
  represents a two-level summary that first summarises
  individual population trajectories and then summarises
  these values over all replicates. Abundances
  can be specified for all population classes or for a subset
  of classes.
}
\examples{
# define a basic population
nstage <- 5
popmat <- matrix(0, nrow = nstage, ncol = nstage)
popmat[reproduction(popmat, dims = 4:5)] <- c(10, 20)
popmat[transition(popmat)] <- c(0.25, 0.3, 0.5, 0.65)

# define a dynamics object
dyn <- dynamics(popmat)

# simulate with the default updater
sims <- simulate(dyn, nsim = 1000)

# calculate expected population size
exps(sims)

# calculate expected population size for 4 and 5 year
#   olds only
exps(sims, subset = 4:5)

# calculate expected population size but ignore first 10 years
exps(sims, times = 11:51)

# calculate expected population size based on median
exps(sims, fun_among = median)

# calculate expected maximum population size based on median
exps(sims, fun_within = max, fun_among = median)

# calculate exps with conflicting quantile functions, handling
#   conflicting arguments with wrapper functions
quant1 <- function(x, p1, ...) {
  quantile(x, prob = p1)
}
quant2 <- function(x, p2, ...) {
  quantile(x, prob = p2)
}
exps(
  sims,
  fun_within = quant1, fun_among = quant2, p1 = 0.25, p2 = 0.75
)
}
