% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{get_cdf}
\alias{get_cdf}
\title{Calculate the cumulative distribution function
  of a summary statistic across all iterations of a
  \code{\link{simulate}} object}
\usage{
get_cdf(sims, subset = NULL, times = NULL, n = 100, fn = min, ...)
}
\arguments{
\item{sims}{an object returned from \code{\link{simulate}}}

\item{subset}{\code{integer} vector denoting the population classes
to include in calculation of population abundance. Defaults to
all classes}

\item{times}{\code{integer} vector specifying generations to
include in calculation of extinction risk. Defaults to all
simulated generations}

\item{n}{\code{integer} specifying number of threshold values
to use in default case when \code{threshold} is not specified.
Defaults to 100}

\item{fn}{function to apply to each iteration. Defaults to min}

\item{\dots}{additional arguments passed to \code{fn}}
}
\value{
a data.frame containing a \code{prob} column that indicates
  the probability the population will fall below the threshold value
  in the \code{value} column
}
\description{
Calculate the cumulative distribution function
  of a summary statistic across all iterations of a
  \code{\link{simulate}} object
}
\details{
\code{get_cdf} is a faster and more
  general alternative to the \code{risk_curve} function.
  \code{get_cdf} can be used to calculate the cumulative
  distribution of any summary statistic. For example, the
  cumulative distribution of the minimum population size
  is equivalent to a risk curve. Summary statistics for
  \code{get_cdf} are extracted from a \code{\link{simulate}}
  object and represent the cumulative distribution of that
  statistic over all replicate trajectories at any time step
  within a set period. Abundances can be specified for all
  population classes or for a subset of classes.
}
\examples{
# define a basic population
nstage <- 5
popmat <- matrix(0, nrow = nstage, ncol = nstage)
popmat[reproduction(popmat, dims = 4:5)] <- c(10, 20)
popmat[transition(popmat)] <- c(0.25, 0.3, 0.5, 0.65)

# define a dynamics object
dyn <- dynamics(popmat)

# simulate with the default updater
sims <- simulate(dyn, nsim = 1000)

# calculate distribution of minimum population sizes (default)
get_cdf(sims)

# calculate distribution of maximum population sizes
get_cdf(sims, fn = max)

# calculate distribution of the 90th percentile of
#   population sizes
get_cdf(sims, fn = quantile, prob = 0.9)

# calculate distribution of minimum population sizes
#   but ignore first 10 years
get_cdf(sims, fn = max, times = 11:51)
}
