% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multispecies.R
\name{pairwise_interaction}
\alias{pairwise_interaction}
\title{Specify interactions between two species}
\usage{
pairwise_interaction(target, source, masks, funs)
}
\arguments{
\item{target}{population whose vital rates are affected by the
pairwise interaction}

\item{source}{population whose abundances affect the vital rates
of \code{target}}

\item{masks}{masks defining which vital rates are influenced by
each function}

\item{funs}{functions that take vital rates and abundances of the
\code{source} population as inputs and return scaled vital rates}
}
\value{
\code{pairwise_interaction} object specifying links between
  species; for use with \code{\link{multispecies}}
}
\description{
Define population dynamics for multiple species from
  a set of single-species \code{\link{dynamics}} objects and
  defined pairwise interactions.
}
