% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{risk_curve}
\alias{risk_curve}
\title{Calculate (quasi-)extinction risk at multiple thresholds
  for a \code{\link{simulate}} object}
\usage{
risk_curve(sims, threshold = NULL, subset = NULL, times = NULL, n = 100)
}
\arguments{
\item{sims}{an object returned from \code{\link{simulate}}}

\item{threshold}{\code{integer} or \code{numeric} vector
denoting the set of threshold population sizes used to define
the risk curve. Defaults to \code{n} evenly spaced values
from 0 to the maximum observed abundance}

\item{subset}{\code{integer} vector denoting the population classes
to include in calculation of population abundance. Defaults to
all classes}

\item{times}{\code{integer} vector specifying generations to
include in calculation of extinction risk. Defaults to all
simulated generations}

\item{n}{\code{integer} specifying number of threshold values
to use in default case when \code{threshold} is not specified.
Defaults to 100}
}
\value{
a named vector containing the threshold values (names) and the
  probability the population will fall below these threshold values
}
\description{
Calculate (quasi-)extinction risk at multiple thresholds
  for a \code{\link{simulate}} object
}
\details{
Risk curves represent \code{\link{pr_extinct}} at multiple
  threshold population sizes simultaneously. This gives an expression
  of risk of population declines below a range of values. Risk curves
  are extracted from a \code{\link{simulate}} object as the
  proportion of replicate trajectories that fall below each
  threshold value at any time step within a set period. Abundances
  can be specified for all population classes or for a subset
  of classes.

  The \code{\link{get_cdf}} function is a much faster way to generate
  risk curves for almost all use cases. The exception is when the
  \code{threshold} argument is used to specify threshold values that
  are not evenly spaced.
}
\examples{
# define a basic population
nstage <- 5
popmat <- matrix(0, nrow = nstage, ncol = nstage)
popmat[reproduction(popmat, dims = 4:5)] <- c(10, 20)
popmat[transition(popmat)] <- c(0.25, 0.3, 0.5, 0.65)

# define a dynamics object
dyn <- dynamics(popmat)

# simulate with the default updater
sims <- simulate(dyn, nsim = 100)

# calculate risk curve
risk_curve(sims, n = 10)
}
