% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_adf.R
\name{adf_file_con}
\alias{adf_file_con}
\alias{adf_file_con.adf_device}
\alias{adf_file_con.adf_device.character}
\alias{adf_file_con.virtual_path}
\title{Open a connection to a file on a virtual ADF device}
\usage{
adf_file_con(x, ..., writable = FALSE)

\method{adf_file_con}{adf_device}(x, path, ..., writable = FALSE)

\method{adf_file_con.adf_device}{character}(x, path, ..., writable = FALSE)

\method{adf_file_con}{virtual_path}(x, ..., writable = FALSE)
}
\arguments{
\item{x}{Either a connection to a virtual ADF device created with \code{\link[=connect_adf]{connect_adf()}},
or a \code{virtual_path} created with \code{\link[=virtual_path]{virtual_path()}}.}

\item{...}{Ignored.}

\item{writable}{A \code{logical} value. When \code{TRUE} the connection can be used to
write to the file on the virtual device. When \code{FALSE} it can only be used to read.
Note that a writeable connection can only be setup on a virtual device that is
not write protected.}

\item{path}{Only required when \code{x} is a virtual device of class \code{adf_device}.
In that case \code{path} should be a character string representing the
path to the file on the virtual device. See also \code{vignette("virtual_paths")}.}
}
\value{
Returns an R connection that can be handled by any function that
accepts a connection for reading or writing. Remember to call \code{\link[=close]{close()}} after
use.
}
\description{
Open a connection to a file on a virtual ADF device. The created connection (if valid)
should be accepted by any R function that reads from or writes to a connection,
such as \code{\link[=readLines]{readLines()}}, \code{\link[=writeLines]{writeLines()}}, \code{\link[=readBin]{readBin()}}, \code{\link[=writeBin]{writeBin()}}, etc.
}
\examples{
## First setup a connection to a virtual device
adz_file <- system.file("example.adz", package = "adfExplorer")
my_device <- connect_adf(adz_file)

## Open a connection to a file on the virtual device
fcon <- adf_file_con(my_device, "DF0:s/startup-sequence")

## Read from the file
my_startup <- readLines(fcon, warn = FALSE)

## Close the file
close(fcon)

## Close the virtual device
close(my_device)
}
\author{
Pepijn de Vries
}
