% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undelete.R
\name{adf_dumpster_dive}
\alias{adf_dumpster_dive}
\alias{salvage_adf_entry}
\title{Salvage entries on ADF disks}
\usage{
adf_dumpster_dive(dev, vol = 0L, ...)

salvage_adf_entry(dev, vol = 0L, sector, ...)
}
\arguments{
\item{dev}{The virtual adf device for which information needs to be obtained.
It should be of class \code{adf_device} which can be created with \code{\link[=create_adf_device]{create_adf_device()}}
or \code{\link[=connect_adf]{connect_adf()}}.}

\item{vol}{Volume index number on the device starting at \code{0}. Default is \code{0}.
Note that floppy disks can only have 1 volume installed.}

\item{...}{Ignored}

\item{sector}{Sector number of the file/directory header that you wish to
salvage}
}
\value{
In case of \code{adf_dumpster_dive()} a \code{data.frame} is returned
with records that could potentially be salvaged from the disk.
In case of \code{salvage_adf_entry()}, the \code{disk} (\code{adf_device} class object)
is returned, where (if successful) the record is restored.
}
\description{
Functions to attempt to salvage files and directories from
virtual disks (ADF).
}
\details{
When a file or directory is removed from a virtual device (or
a physical device for that matter), the record is removed from
its parent directory hash table and its bitmap flags are flipped to
mark the file blocks as available. This means that the actual
record of the file and its contents is still on the disk, until
they are overwritten. You can use these functions to salvage such
entries.

You can use \code{adf_dumster_dive()} to scan for entries that could
potentially be salvaged. Than you can use \code{salvage_adf_entry()}
to attempt to salvage an entry.

Note that these functions won't work when you have flushed the file
(see \code{\link[=remove_adf_entry]{remove_adf_entry()}}). In that case the actual record of the file
and its data have been permanently removed.
}
\examples{
my_device <- demo_adf(write_protected = FALSE)
# The demo disk contains a deleted file that could be salvaged:
salvageable <- adf_dumpster_dive(my_device)

# Let's recover it:
salvage_adf_entry(my_device, sector = salvageable$sect)

# It is now listed as an entry on the disk:
list_adf_entries(my_device, recursive = TRUE)

close(my_device)
}
