% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_equal_knownComp}
\alias{is_equal_knownComp}
\title{Equality of known components in two admixture models}
\usage{
is_equal_knownComp(admixMod1, admixMod2)
}
\arguments{
\item{admixMod1}{An object of class \code{admix_model} related to the first admixture model.}

\item{admixMod2}{An object of class \code{admix_model} related to the second admixture model.}
}
\value{
A boolean (TRUE if the known components are the same, otherwise FALSE).
}
\description{
Test if the known component distributions coming from two admixture models are identical.
}
\examples{
admixMod1 <- admix_model(knownComp_dist = "norm",
                         knownComp_param = list("mean"=0, "sd"=1))
admixMod2 <- admix_model(knownComp_dist = "norm",
                         knownComp_param = list("mean"=0, "sd"=1))
is_equal_knownComp(admixMod1, admixMod2)

admixMod1 <- admix_model(knownComp_dist = "multinom",
                         knownComp_param = list("size"=1, "prob"=c(0.2,0.5,0.3)))
admixMod2 <- admix_model(knownComp_dist = "multinom",
                         knownComp_param = list("size"=1, "prob"=c(0.2,0.4,0.4)))
is_equal_knownComp(admixMod1, admixMod2)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
