% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{ks_test}
\alias{ks_test}
\title{ks_test}
\usage{
ks_test(df, variable_name, group)
}
\arguments{
\item{df}{A data frame.}

\item{variable_name}{Name of the response variable column (string).}

\item{group}{Name of the grouping column (string).}
}
\value{
A named list with elements \code{ks_results}, \code{dunn_results},
  \code{mean_summary}, and \code{compact_letters}.
}
\description{
Perform Kruskal-Wallis test followed by Dunn post-hoc test
  (Bonferroni correction) with compact letter display.
}
\examples{
df <- data.frame(
  grp = rep(c("A","B","C"), each = 5),
  val = c(1,2,1,2,1, 3,4,3,4,3, 5,6,5,6,5)
)
ks_test(df, "val", "grp")
}
