% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_line}
\alias{plot_line}
\title{plot_line}
\usage{
plot_line(
  df,
  x,
  y,
  z = NULL,
  base_size = 25,
  line_width = 3,
  text_color = "black",
  facet = FALSE,
  facet_x = NULL,
  facet_y = NULL,
  style = "bw"
)
}
\arguments{
\item{df}{A data frame.}

\item{x}{<[`data-masking`][ggplot2::aes]> Column mapped to the x-axis.}

\item{y}{<[`data-masking`][ggplot2::aes]> Column mapped to the y-axis.}

\item{z}{<[`data-masking`][ggplot2::aes]> Optional column mapped to colour and group.}

\item{base_size}{Base font size. Default 25.}

\item{line_width}{Line width. Default 3.}

\item{text_color}{Text colour. Default \code{"black"}.}

\item{facet}{Logical; add facet grid? Default \code{FALSE}.}

\item{facet_x}{Column name (string) for the horizontal facet dimension.}

\item{facet_y}{Column name (string) for the vertical facet dimension.}

\item{style}{Theme style. Default \code{"bw"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a line plot using the aelab theme.
}
\examples{
\dontrun{
df <- data.frame(x = 1:6, y = c(1,3,2,5,4,6), g = rep(c("A","B"), 3))
plot_line(df, x, y, g)
}
}
