testthat::test_that("afm_check 0 length", {
  testthat::expect_equal(afm_check(character(0)), logical(0))
})

testthat::test_that("afm_check NA_character_", {
  testthat::expect_false(afm_check(NA_character_))
})

test_that("afm_check too long or too short", {
  expect_false(afm_check("0100000070"))
  expect_false(afm_check("01000000"))
})

test_that("afm_check non-numeric characters", {
  expect_false(afm_check("BADAFM990"))
  expect_false(afm_check("BADAFM991"))
  expect_false(afm_check("BADAFM992"))
  expect_false(afm_check("BADAFM993"))
  expect_false(afm_check("BADAFM994"))
  expect_false(afm_check("BADAFM995"))
  expect_false(afm_check("BADAFM996"))
  expect_false(afm_check("BADAFM997"))
  expect_false(afm_check("BADAFM998"))
  expect_false(afm_check("BADAFM999"))
})

test_that("afm_check bad checksum digit", {
  expect_false(afm_check("010000000"))
  expect_false(afm_check("010000001"))
  expect_false(afm_check("010000002"))
  expect_false(afm_check("010000003"))
  expect_false(afm_check("010000004"))
  expect_false(afm_check("010000005"))
  expect_false(afm_check("010000006"))
  expect_false(afm_check("010000008"))
  expect_false(afm_check("010000009"))

  expect_false(afm_check("123456780"))
  expect_false(afm_check("123456789"))
})

test_that("afm_check correct FIGI", {
  expect_true(afm_check("010000007"))
  expect_true(afm_check("011111111"))
  expect_true(afm_check("123456783"))
})

test_that("afm_check test character vector", {
  res <- c(TRUE, FALSE, FALSE, FALSE)
  expect_equal(afm_check(c("010000007", "123456789", "x", NA_character_)), res)

})


test_that("afm_compute_checksum", {
  expect_equal(afm_compute_checksum("01000000"), "7")
  expect_equal(afm_compute_checksum("12345678"), "3")
})
