% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_methods.R
\name{print.metAgri}
\alias{print.metAgri}
\title{Print an object of class \code{metAgri}}
\usage{
\method{print}{metAgri}(x, ...)
}
\arguments{
\item{x}{An object fitted with the function \code{met_analysis()}.}

\item{...}{Options used by the tibble package to format the output. See
`tibble::print()` for more details.}
}
\value{
an object inheriting from class \code{metAgri}.
}
\description{
Prints information about \code{met_analysis()} function.
}
\examples{
\dontrun{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
met_results <- met_analysis(out, progress = FALSE)
print(met_results)
}
}
\author{
Johan Aparicio [aut]
}
