% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edist.R
\name{conditional.edist}
\alias{conditional.edist}
\title{Conditional distribution for expression distributions.}
\usage{
\method{conditional}{edist}(x, P, ...)
}
\arguments{
\item{x}{An \code{edist} object.}

\item{P}{Predicate function to condition on.}

\item{...}{Additional arguments forwarded to the predicate \code{P}.}
}
\value{
A conditional \code{empirical_dist}.
}
\description{
Falls back to \code{\link{realize}} and delegates to
\code{\link{conditional.empirical_dist}}.
}
\examples{
\donttest{
set.seed(1)
z <- normal(0, 1) + exponential(1)
z_pos <- conditional(z, function(t) t > 2)
mean(z_pos)
}
}
