% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_dist.R
\name{inv_cdf.weibull_dist}
\alias{inv_cdf.weibull_dist}
\title{Inverse CDF (quantile function) for a Weibull distribution.}
\usage{
\method{inv_cdf}{weibull_dist}(x, ...)
}
\arguments{
\item{x}{A \code{weibull_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(p, lower.tail = TRUE, log.p = FALSE, ...)}
returning the quantile at probability \code{p}.
}
\description{
Returns a function that computes quantiles of the Weibull distribution.
}
\examples{
x <- weibull_dist(shape = 2, scale = 3)
q <- inv_cdf(x)
q(0.5)
q(0.95)
}
