test_that("rocperfmatrix",{
  ## ========================================================
  library(alternativeROC)
  library(pROC)
  ## ========================================================
  dp <- FALSE
  if(dp) par(mfrow=c(2,2))
  for(seed in 1:3) {
    cat("*")
    set.seed(seed)
    count.neg <- round(runif(1,10,200))
    count.pos <- round(runif(1,10,200))
    sd.neg <- sd.pos <- 1
    mean.neg <- runif(1)
    mean.pos <- 1
    skew.neg <- runif(1,-10,10)
    skew.pos <- 0
    x <- c(sn::rsn(count.neg,mean.neg,sd.neg,skew.neg),
           sn::rsn(count.pos,mean.pos,sd.pos,skew.pos))
    y <- ordered(c(rep("neg",count.neg),rep("pos",count.pos)),levels=c("neg","pos"))
    boot.n <- 2e3
    ## ====
    xz <- matrix(NA,nrow=length(x),ncol=boot.n)
    xz[,1] <- x
    for(i in 2:boot.n) {
      samp.neg <- sample(1:count.neg,size=count.neg,replace=TRUE)
      samp.pos <- sample(1:count.pos,size=count.pos,replace=TRUE)
      xz[,i] <- c(x[samp.neg],x[count.neg + samp.pos])
    }
    ## ====
    cu <- c(.5,.75,.9)
    ro <- roc(y,x,quiet=TRUE)
    pe0 <- rocperf(x,y,sensitivities=cu,specificities=cu,attr=TRUE)
    pe1 <- rocperf(xz,y,sensitivities=cu,specificities=cu,attr=TRUE)
    testthat::expect_true(abs(pe0$AUC.lCI-pe1$AUC.lCI)<1e-2)
    testthat::expect_true(abs(pe0$AUC.uCI-pe1$AUC.uCI)<1e-2)
  }
  ## ========================================================
})

