% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/art_api.R
\name{artRun}
\alias{artRun}
\title{Runs the regression test}
\usage{
artRun(filter = "", verbose = TRUE)
}
\arguments{
\item{filter}{If specified, only tests with names matching this perl regular
expression will be executed. Character vector of length 1. See also \link{artList}}

\item{verbose}{logical. If TRUE (the default), prints version of tested allelematch to stdout}
}
\value{
A list (invisibly) containing data about the test results as returned by \link[testthat:test_package]{testthat::test_package}
}
\description{
Runs regression tests on package \link[allelematch:allelematch-package]{allelematch} to make sure it is backwards compatible.\cr
\cr
The full set of tests will take a couple of minutes. \cr
\cr
Call \link{artList} to see the available tests with without running them.
}
\details{
If any of the test executed with \link{artRun} should fail, then we want to be able
to run that specific test under the debugger.\cr
\cr
Set a breakpoint in \code{allelematch.R} and call \code{artRun(filter="<the test that reproduces the problem>")}\cr
\cr
Note that it is the last loaded version of \code{allelematch} that will be executed,
not the last edited. In RStudio, CTRL+SHIFT+B will build, install and load.
}
\examples{
# See what version of packages 'allelematch' and 'amregtest'
# are currently loaded:
artVersion()

# List the available tests:
artList()
\donttest{
# Run all the tests:
# artRun()  # Takes several minutes

# Run the first of the available tests:
artRun(filter="allelematch_1-amDataset$")
}

}
\seealso{
\link{artVersion} and \link{artList}
}
