## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----load-and-setup, echo=FALSE, message=FALSE, warning=FALSE-----------------
library(andorR)
library(dplyr)
data(ethical) 

## ----setup-tree---------------------------------------------------------------
library(andorR)

# Load the built-in ethical dataset
data(ethical)
dtree <- load_tree_df(ethical)

## ----calculate-indices--------------------------------------------------------
# Calculate all indices for the initial state
dtree <- update_tree(dtree)

## ----print-indices------------------------------------------------------------
print(dtree, "rule", true = "true_index", false = "false_index", influence = "influence_index")

## ----get-influence------------------------------------------------------------
get_highest_influence(dtree, top_n = 3)

## ----get-initial-influence----------------------------------------------------
# Get a full list of all question statuses
all_questions <- get_questions(dtree)

# Let's look at the initial influence of FIN1, FIN2, and FIN4
all_questions %>% 
  filter(name %in% c("FIN1", "FIN2", "FIN4")) %>%
  knitr::kable()

## ----answer-and-recalculate---------------------------------------------------
# Answer a question and then run update_tree() again
set_answer(dtree, "FIN1", TRUE, 5)
dtree <- update_tree(dtree)

## ----get-new-influence--------------------------------------------------------
# Get the new list of all question statuses
all_questions_new <- get_questions(dtree)

# Look at the new influence of FIN2 and FIN4
all_questions_new %>% 
  filter(name %in% c("FIN1", "FIN2", "FIN4")) %>%
  knitr::kable()

