% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tree.R
\name{load_tree_df}
\alias{load_tree_df}
\title{Build a decision tree from a relational data frame}
\usage{
load_tree_df(df)
}
\arguments{
\item{df}{A data frame with columns: id, name, question, rule, parent.}
}
\value{
A \code{data.tree} object, fully constructed and initialised with \code{answer}
and \code{confidence} attributes set to \code{NA}.
}
\description{
Constructs and initialises a tree from a data frame that is
already in memory, where the hierarchy is defined in a relational
(ID/parent) format.
}
\details{
This is a core constructor function. It may be used to load one of
the example datasets in relational format. It is called by the
\code{load_tree_csv()} wrapper, which handles reading the data from a file.
}
\examples{
# Load a tree from the 'ethical' dataframe included in this package
ethical_tree <- load_tree_df(ethical)

# View the tree structure
\dontrun{
print_tree(ethical_tree)
}
}
\seealso{
\code{\link[=load_tree_csv]{load_tree_csv()}} to read this format from a file.
}
