% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_box}
\alias{plot_box}
\title{Plot bounding boxes on image from md results}
\usage{
plot_box(
  rows,
  file_col = "filepath",
  min_conf = 0,
  label_col = NULL,
  show_confidence = FALSE,
  colors = NULL,
  detector_labels = NULL,
  return_img = FALSE
)
}
\arguments{
\item{rows}{row or rows of images in which the bounding box will be plotted}

\item{file_col}{Column name containing file paths}

\item{min_conf}{minimum confidence to plot box}

\item{label_col}{Column name containing class to print above the box. If None, no label is printed.}

\item{show_confidence}{If true, show confidence score above the box.}

\item{colors}{Named list mapping class labels to BGR color tuples for the bounding boxes.}

\item{detector_labels}{Named list mapping detector categories to human-readable labels.}

\item{return_img}{If true, return the image array with boxes overlaid, otherwise display it}
}
\value{
no return value, produces bounding box in plot panel
}
\description{
Plot bounding boxes on image from md results
}
\examples{
\dontrun{
test_image <- classify(classifier_model, test_image, file_col='filepath')
plot_box(test_image, file_col='filepath', minconf = 0.5, prediction=TRUE)
}
}
