% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMCRMethods.R
\docType{methods}
\name{CMCR-Methods}
\alias{CMCR-Methods}
\alias{cmcr-methods}
\alias{cmcr,ANY-method}
\alias{cmcr,Bertrand-method}
\alias{cmcr,Auction2ndLogit-method}
\alias{cmcr,Cournot-method}
\alias{cmcr,AIDS-method}
\title{Methods For Calculating Compensating Marginal Cost Reductions}
\usage{
\S4method{cmcr}{Bertrand}(object, market = FALSE, levels = FALSE, rel = c("cost", "price"))

\S4method{cmcr}{Cournot}(object, market = TRUE, levels = FALSE, rel = c("cost", "price"))

\S4method{cmcr}{AIDS}(object, market = FALSE, rel = c("cost", "price"))

\S4method{cmcr}{Auction2ndLogit}(object, market = FALSE, levels = FALSE, rel = c("cost", "price"), ...)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{market}{If TRUE, calculates (post-merger) share-weighted average of metric. Default is FALSE.}

\item{levels}{If TRUE calculates CMCR in levels rather than as a percentage of pre-merger costs. Default is FALSE.}

\item{rel}{A length 1 character vector indicating whether CMCR should be calculated
relative to pre-merger cost (``cost'') or pre-merger price (``price''), 
Default is ``cost''. Ignored when levels is TRUE.}

\item{...}{Additional arguments to pass to \code{cmcr}.}
}
\value{
\code{cmcr} returns a vector of length k equal to CMCR for the
merging parties' products and 0 for all other products.
}
\description{
Calculate the marginal cost reductions necessary to restore
premerger prices in a merger, or the Upwards Pricing Pressure Index
for the products of merging firms playing a differentiated
products Bertrand pricing game.
}
\details{
\code{cmcr} uses the results from the merger simulation and calibration
methods associates with a particular class to compute the compensating
marginal cost reduction (CMCR) for each of the merging parties' products.
}
\seealso{
\code{\link{cmcr.bertrand}} is a function that calculates CMCR
without the need to first calibrate a demand system and simulate a
merger.
}
\keyword{methods}
