% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aplms.R
\encoding{UTF-8}
\name{aplms}
\alias{aplms}
\alias{print.aplms}
\title{Fitting Additive partial linear models with symmetric errors}
\usage{
aplms(
  formula,
  npc,
  basis,
  Knot,
  data,
  family = Normal(),
  p = 1,
  control = list(tol = 0.001, algorithm1 = c("P-GAM"), algorithm2 = c("BFGS"), Maxiter1 =
    20, Maxiter2 = 25),
  init,
  lam,
  verbose = FALSE
)

\method{print}{aplms}(x, ...)
}
\arguments{
\item{formula}{A symbolic description of the parametric component of the model to be fitted. The details of model specification are given under ‘Details’.}

\item{npc}{A vector of names of non parametric component.}

\item{basis}{A vector of names of the basis to be used for each non parametric covariate.}

\item{Knot}{A vector of the number of knots in each non-linear component of the model.}

\item{data}{A data frame containing the variables in the model}

\item{family}{Symmetric error distribution. The implemented distribution are: \code{Normal()}, \code{LogisI()}, \code{LogisII()}, \code{Student(df)}, \code{Powerexp(k)}, \code{Gstudent(parm=c(s,r))}.}

\item{p}{autoregressive order of the error}

\item{control}{optimization rutine.}

\item{init}{A list of initial values for the symmetric error scale, phi, and autoregressive coefficients, rhos.}

\item{lam}{smoothing parameter vector.}

\item{verbose}{Logical; if TRUE, prints estimation progress messages. Default is FALSE.}

\item{x}{APLMS object.}

\item{...}{other arguments}
}
\value{
Returns an object of class \dQuote{aplms}, a list with following components.
\describe{
\item{formula}{the \code{formula} object used.}
\item{family}{the \code{family} object used.}
\item{npc}{the \code{npc} object used.}
\item{Knot}{the \code{Knot} object used.}
\item{lam}{the \code{lam} object used.}
\item{rdf}{Degrees of freedom: \code{n - q - p - 1}.}
\item{VAR_F}{Estimate the asymptotic covariance matrix for the gamma parameters.}
\item{basis}{The \code{basis} to be used for each non parametric covariate.}
\item{WALD_f}{The summary table of the Wald statistics.}
\item{summary_table_phirho}{The summary table of the rho and phi parameters.}
\item{N_i}{Basis functions.}
\item{f}{Estimated gamma parameters.}
\item{Dv}{Dv values for the symmetric error.}
\item{Dm}{Dm values for the symmetric error.}
\item{Dc}{Dc values for the symmetric error.}
\item{Dd}{Dd values for the symmetric error.}
\item{delta}{delta_i for the symmetric error.}
\item{LL_obs}{Observed information matrix of the fitted model.}
\item{loglike}{The estimated loglikelihood function of the fitted model.}
\item{total_df}{The total effective degree of freedom of the model.}
\item{parametric_df}{The degree of freedom of the parametric components.}
\item{npc_df}{The effective degree of freedom of the non parametric components.}
\item{AIC}{Akaike information criterion of the estimated model.}
\item{BIC}{Bayesian information criterion of the estimated model.}
\item{AICC}{Corrected Akaike information criterion of the estimated model.}
\item{GCV}{The generalized cross-validation (GCV).}
\item{yhat}{The fitted response values of the model.}
\item{muhat}{The fitted mean values of the model.}
\item{residuals_y}{The response residuals}
\item{residuals_mu}{Raw (Ordinary) residuals: \eqn{y_t - (\textbf{x}_i^\top\beta + f_1(t_{i1}) + \ldots + f_k(t_{ik}))}}
\item{data}{the \code{data} object used.}
\item{this.call}{the function call used.}
}
}
\description{
\code{aplms} fits additive partial linear models with autoregressive symmetric errors.
This method is suitable for data sets where the response variable is continuous and symmetric,
with either heavy or light tails, and measured over time.
The model includes a parametric component for a set of covariates, while another set of covariates
can be specified as semi-parametric functions, typically time-related.
In this setup, natural cubic splines or cubic P-splines are used to approximate the nonparametric components.
}
\examples{
data(temperature)
temperature.df = data.frame(temperature,time=1:length(temperature))
model<-aplms::aplms(temperature ~ 1,
                   npc=c("time"), basis=c("cr"),Knot=c(60),
                   data=temperature.df,family=Powerexp(k=0.3),p=1,
                   control = list(tol = 0.001,
                                  algorithm1 = c("P-GAM"),
                                  algorithm2 = c("BFGS"),
                                  Maxiter1 = 20,
                                  Maxiter2 = 25),
                   lam=c(10))
plot(model)
summary(model)
print(model)
}
\references{
Chou-Chen, S.W., Oliveira, R.A., Raicher, I., Gilberto A. Paula (2024)
   \emph{Additive partial linear models with autoregressive symmetric errors and its application to the
   hospitalizations for respiratory diseases} Stat Papers 65, 5145–5166. \doi{10.1007/s00362-024-01590-w}

Oliveira, R.A., Paula, G.A. (2021)
   \emph{Additive partial linear models with autoregressive symmetric errors and its application to the
   hospitalizations for respiratory diseases} Comput Stat 36, 2435–2466. \doi{10.1007/s00180-021-01106-2}
}
