% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProfileDendrogram.R
\name{plotProfileDendrogram}
\alias{plotProfileDendrogram}
\title{Plot soil profiles below a dendrogram or cladogram}
\usage{
plotProfileDendrogram(
  x,
  clust,
  rotateToProfileID = FALSE,
  scaling.factor = 5 * mean(clust$height)/max(x),
  width = 0.25,
  y.offset = 60 * mean(clust$height)/max(x),
  dend.y.scale = max(clust$height * 2, na.rm = TRUE),
  dend.color = par("fg"),
  dend.width = 1,
  dend.type = c("phylogram", "cladogram"),
  debug = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}

\item{clust}{a hierarchical clustering object generated by \code{hclust()}, \code{cluster::agnes()}, or \code{cluster::diana()}}

\item{rotateToProfileID}{logical, attempt rotation of dendrogram according to original profile IDs, requires \code{dendextend} package}

\item{scaling.factor}{numeric, vertical scaling of the profile heights (default estimate printed if not specified)}

\item{width}{numeric, scaling of profile widths}

\item{y.offset}{numeric, vertical offset for top of profiles (default estimate printed if not specified)}

\item{dend.y.scale}{numeric, scaling of dendrogram (default estimate printed if not specified)}

\item{dend.color}{dendrogram line color}

\item{dend.width}{dendrogram line width}

\item{dend.type}{dendrogram type, passed to \code{plot.phylo()}, either "phylogram" or "cladogram"}

\item{debug}{logical, optionally print debugging data and return a \code{data.frame} of linking structure}

\item{...}{additional arguments to \code{plotSPC()}}
}
\value{
This function is typically called to create graphical output, when \code{debug = TRUE} a \code{data.frame} of IDs and linking structure used to build the figure.
}
\description{
Plot soil profiles below a dendrogram, using methods from the ape package.
}
\note{
The default values of \code{scaling.factor}, \code{y.offset}, and \code{dend.y.scale} are based on \code{clust$height} and \code{max(x)}, and should be close to optimal. Use the defaults as a starting point for finer control.
}
\author{
D.E. Beaudette
}
\keyword{hplots}
