% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-spatial-filter.R
\name{prepare_spatial_filter}
\alias{prepare_spatial_filter}
\alias{match_spatial_rel}
\title{Prepare JSON for use as a spatial filter based on feature geometry or
bounding box input}
\usage{
prepare_spatial_filter(
  filter_geom,
  crs,
  predicate,
  error_call = rlang::caller_env()
)

match_spatial_rel(predicate, error_call = rlang::caller_env())
}
\arguments{
\item{filter_geom}{an object of class \code{bbox}, \code{sfc} or \code{sfg} used to filter
query results based on a predicate function.}

\item{crs}{a representation of a coordinate reference system.}

\item{predicate}{Spatial predicate to use with \code{filter_geom}. Default
\code{"intersects"}. Possible options are \code{"intersects"}, \code{"contains"},
\code{"crosses"},  \code{"overlaps"},  \code{"touches"}, and \code{"within"}.}

\item{error_call}{default \code{rlang::caller_env()}.}
}
\value{
\code{\link[=prepare_spatial_filter]{prepare_spatial_filter()}} returns a named list with the
\code{geometryType}, \code{geometry} (as Esri JSON), and spatial relation predicate.

\code{\link[=match_spatial_rel]{match_spatial_rel()}} returns one of the following spatial binary predicates:
\itemize{
\item esriSpatialRelIntersects
\item esriSpatialRelContains
\item esriSpatialRelCrosses
\item esriSpatialRelOverlaps
\item esriSpatialRelTouches
\item esriSpatialRelWithin
}
}
\description{
\code{\link[=prepare_spatial_filter]{prepare_spatial_filter()}} prepares a named list with ESRI JSON geometry for
use as a spatial filter based on a a \code{sfc}, \code{sfg}, or \code{bbox} input object.

\code{\link[=match_spatial_rel]{match_spatial_rel()}} takes a scalar character vector with a predicate name
to a type of ESRI spatial relation.
}
\details{
Using \code{sfc} objects as \code{filter_geom}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

If an \code{sfc} object is provided it will be transformed to the layers spatial
reference. If the \code{sfc} is missing a CRS (or is an \code{sfg} object) it is
assumed to use the same spatial reference as the FeatureLayer. If the \code{sfc}
object has multiple features, the features are unioned with
\code{\link[sf:geos_combine]{sf::st_union()}}. If an \code{sfc} object has \code{MULTIPOLYGON} geometry, the
features are cast to \code{POLYGON} geometry and only the first element is used.
}
\examples{
prepare_spatial_filter(sf::st_point(c(0, 5)), 4326, "intersects")
}
