% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archipelago.R
\name{archipelago_plot}
\alias{archipelago_plot}
\title{Archipelago Plot}
\arguments{
\item{df1}{A dataframe of variant-set data.}

\item{df2}{A dataframe of variant data.}

\item{plot_title}{Title for the plot.}

\item{add_title}{Logical; add title if TRUE.}

\item{plot_subtitle}{Subtitle for the plot.}

\item{add_subtitle}{Logical; add subtitle if TRUE.}

\item{chr_ticks}{Logical; show chromosome ticks if TRUE.}

\item{show_legend}{Logical; display the legend if TRUE.}

\item{color_theme}{Name of the colour theme.}

\item{custom_colors}{Vector of custom colours.}

\item{color_labels}{Labels for the colour groups.}

\item{crit_val}{Critical p-value threshold.}

\item{point_size}{Size of the points.}

\item{point_size_large}{Size of the large points of interest such as VSAT.}

\item{fig_width}{Width of the archipelago plot.}

\item{fig_height}{Height of the archipelago plot.}

\item{raw_fig_width}{Width of the raw plot.}

\item{raw_fig_height}{Height of the raw plot.}

\item{output_path}{File path for the plot.}

\item{output_raw}{File path for the raw plot.}

\item{file_type}{Use .png, .jpg, or .pdf. Defaults to png. pdf is slow and large for many SNPs.}

\item{alpha_point}{Use the alpha_point value to set point transparency.}

\item{alpha_seg}{Use the alpha_segvalue to set line segment transparency.}

\item{better_space}{Use better_space = TRUE to make sure that x-axis chr do not squash.}

\item{legend_position}{Default right, allows bottom top left right.}

\item{annotate_thresholds}{Logical; if TRUE, annotate plot with VSAT and single-variant p-value thresholds.}
}
\value{
A ggplot object.
}
\description{
Plot p-values from variant and variant-set tests.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
data("vsat_pval")
data("variant_pval")
archipelago_plot(vsat_pval, variant_pval)
\dontshow{\}) # examplesIf}
}
