% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoe_class.R
\name{plot.aoe_result}
\alias{plot.aoe_result}
\title{Plot method for aoe_result}
\usage{
\method{plot}{aoe_result}(
  x,
  support_id = NULL,
  show_aoe = TRUE,
  show_original = TRUE,
  col_core = "#2E7D32",
  col_halo = "#F57C00",
  col_original = "#000000",
  col_aoe = "#9E9E9E",
  pch = 16,
  cex = 0.8,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{An aoe_result object}

\item{support_id}{Optional: filter to specific support(s)}

\item{show_aoe}{Logical; show AoE boundary (default TRUE)}

\item{show_original}{Logical; show original support boundary (default TRUE)}

\item{col_core}{Color for core points (default "#2E7D32", green)}

\item{col_halo}{Color for halo points (default "#F57C00", orange)}

\item{col_original}{Color for original support boundary (default "#000000")}

\item{col_aoe}{Color for AoE boundary (default "#9E9E9E")}

\item{pch}{Point character (default 16)}

\item{cex}{Point size (default 0.8)}

\item{main}{Plot title (default auto-generated)}

\item{...}{Additional arguments passed to plot}
}
\value{
Invisibly returns x
}
\description{
Visualize an AoE classification result, showing points colored by class
and optionally the support and AoE boundaries.
}
\examples{
library(sf)

support <- st_as_sf(
  data.frame(id = 1),
  geometry = st_sfc(st_polygon(list(
    cbind(c(0, 10, 10, 0, 0), c(0, 0, 10, 10, 0))
  ))),
  crs = 32631
)

set.seed(42)
pts <- st_as_sf(
  data.frame(id = 1:50),
  geometry = st_sfc(lapply(1:50, function(i) {
    st_point(c(runif(1, -5, 15), runif(1, -5, 15)))
  })),
  crs = 32631
)

result <- aoe(pts, support)
plot(result)

}
