#' Annual January levels of lake Michigan-Huron
#'
#' The dataset is a subset of the monthly average depth (ft) of lake
#' Michigan-Huron. The data were retrieved online from  the
#' Great Lakes Environmental Research Laboratory. Various measurement gauges
#' exist; this data was taken from the master gauge.
#'
#' @format ## `miHuron_level`
#' A data frame with 155 observations and two columns:
#' \describe{
#'   \item{Date}{`Date` column that records when the observation was made.}
#'   \item{Average}{`numeric` column representing the average depth in feet.}
#' }
#' @source
#' NOAA. Annual January levels of lake Michigan-Huron. Great Lakes Environmental Research Laboratory, https://www.glerl.noaa.gov/data/dashboard/data/levels/mGauge/miHuronMog.csv. Accessed 08/24/2023.
#'
#' The original url used to obtain the data no longer exists, but a partial subset of the same data can be found at <https://www.greatlakescc.org/en/coordinating-committee-products-and-datasets/> under the subsection: Monthly Mean Water Levels.
#'
"miHuron_level"
