% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/art_pals.R
\name{art_pals}
\alias{art_pals}
\title{Custom-built artpack Color Palettes}
\usage{
art_pals(pal = NULL, n = 5, direction = "regular", randomize = FALSE)
}
\arguments{
\item{pal}{A character string of the desired artpack palette.

The 18 artpack palettes include:
\itemize{
\item "arctic" - Icy blue and white colors
\item "beach" - Sand-colored tans and ocean-colored blue colors
\item "bw" - A gradient of black to white colors
\item "brood" - A gradient of different shades of dark gray and black colors
\item "cosmos" - Nebula-inspired blue, purple, and pink colors
\item "explorer" - Pokemon-type inspired colors
\item "gemstones" - Birthstone/Mineral-inspired colors
\item "grays" - A gradient of dark, medium, and light gray colors
\item "icecream" - A light pastel palette of cream, blue, brown, and pink colors
\item "imagination" - 90's school supply-inspired colors
\item "majestic" - Shades of majestic purple colors
\item "nature" - A mix of tan, brown, green, and red colors
\item "neon" - A neon spectrum of rainbow colors
\item "ocean" - A gradient of dark to light blue colors
\item "plants" - A gradient of dark to light green colors
\item "rainbow" - A vibrant mix of rainbow colors
\item "sunnyside" - A retro-inspired mix of pink, orange, and yellow colors
\item "super" - A marveling mix of heroic colors
}}

\item{n}{The numbers of colors desired in the output.

Default is \code{5}. \code{n} must be a positive integer with a value greater than 0}

\item{direction}{The direction of the palette

Default is "regular". Only two options accepted: "regular" or "reverse"}

\item{randomize}{Determines if the colors in the palette appear in a randomized order.

Default is \code{FALSE}. Boolean where only \code{TRUE} or \code{FALSE} is accepted.}
}
\value{
A Character Vector.
}
\description{
The artpack palette picker. The \code{art_pals} function consists of 18 palettes: "arctic",
"beach", "bw", "brood", "cosmos", "explorer", "gemstones", "grays", "icecream", "imagination",
"majestic", "nature", "neon", "ocean", "plants", "rainbow", "sunnyside", "super"
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) withAutoprint(\{ # examplesIf}
\dontshow{\}) # examplesIf}
library(ggplot2)
dots <- data.frame(x = c(1:10), y = 2.5)
dots$fills <- art_pals("rainbow", 10)

dots |>
  ggplot(aes(x, y)) +
  theme_void() +
  geom_point(
    shape = 21,
    fill = dots$fills,
    color = "#000000",
    size = 10,
    stroke = 2
  )


dots_rev <- data.frame(x = c(1:10), y = 2.5)
dots_rev$fills <- art_pals("rainbow", 10, "reverse")

dots_rev |>
  ggplot(aes(x, y)) +
  theme_void() +
  geom_point(
    shape = 21,
    fill = dots_rev$fills,
    color = "#000000",
    size = 10,
    stroke = 2
  )

dots_random <- data.frame(x = c(1:10), y = 2.5)
dots_random$fills <- art_pals("rainbow", 10, randomize = TRUE)

dots_random |>
  ggplot(aes(x, y)) +
  theme_void() +
  geom_point(
    shape = 21,
    fill = dots_random$fills,
    color = "#000000",
    size = 10,
    stroke = 2
  )

}
