% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\alias{inspect,itemsets-method}
\alias{inspect,rules-method}
\alias{inspect,transactions-method}
\alias{inspect,itemMatrix-method}
\alias{inspect,tidLists-method}
\title{Display Associations and Transactions in Readable Form}
\usage{
inspect(x, ...)

\S4method{inspect}{itemsets}(x, itemSep = ", ", setStart = "{", setEnd = "}", linebreak = NULL, ...)

\S4method{inspect}{rules}(
  x,
  itemSep = ", ",
  setStart = "{",
  setEnd = "}",
  ruleSep = "=>",
  linebreak = NULL,
  ...
)

\S4method{inspect}{transactions}(x, itemSep = ", ", setStart = "{", setEnd = "}", linebreak = NULL, ...)

\S4method{inspect}{itemMatrix}(x, itemSep = ", ", setStart = "{", setEnd = "}", linebreak = NULL, ...)

\S4method{inspect}{tidLists}(x, ...)
}
\arguments{
\item{x}{a set of \link{associations} or \link{transactions} or an \link{itemMatrix}.}

\item{...}{additional arguments.
can be used to customize the output:}

\item{itemSep}{item separator}

\item{setStart}{set start symbol}

\item{setEnd}{set end symbol}

\item{linebreak}{print only one element per line in case the output lines get very long?}

\item{ruleSep}{rule separator}
}
\value{
Nothing is returned (see the Details Section).
}
\description{
Provides the generic function \code{inspect()} and methods to display
\link{associations} and \link{transactions} plus additional information formatted for
online inspection.
}
\details{
\code{inspect()} prints the results directly. If you need to create a data.frame
with a human readable version, then you can use \code{\link[=DATAFRAME]{DATAFRAME()}}.
}
\examples{
data("Adult")
rules <- apriori(Adult)

## display some rules
inspect(rules[1000:1001])
inspect(rules[1000:1001],
  ruleSep = "~~>", itemSep = " + ", setStart = "", setEnd = "",
  linebreak = FALSE
)

## to get rules in readable format, use coercion or DATAFRAME with additional parameters.
as(rules[1000:1001], "data.frame")
DATAFRAME(rules[1000:1001])
DATAFRAME(rules[1000:1001], separate = TRUE, setStart = "", setEnd = "")

}
\seealso{
Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{c}()},
\code{\link{crossTable}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{is.superset}()},
\code{\link{itemFrequency}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler and Kurt Hornik
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{print}
