% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R, R/rotation.R
\name{astro_horizon_from_vector}
\alias{astro_horizon_from_vector}
\title{Convert Cartesian Vector to Horizontal Coordinates}
\usage{
astro_horizon_from_vector(vector, refraction = 1L)

astro_horizon_from_vector(vector, refraction = 1L)
}
\arguments{
\item{vector}{A list with components:
\describe{
\item{x}{North component in AU}
\item{y}{West component in AU}
\item{z}{Zenith (up) component in AU}
\item{t}{The date and time (POSIXct)}
}}

\item{refraction}{Refraction option (0 = REFRACTION_NONE, 1 = REFRACTION_NORMAL, 2 = REFRACTION_JPLHOR).
REFRACTION_NORMAL: correct altitude for atmospheric refraction (recommended).
REFRACTION_NONE: no atmospheric refraction correction is performed.
REFRACTION_JPLHOR: for JPL Horizons compatibility testing only; not recommended for normal use.}
}
\value{
A list representing horizontal coordinates with elements:
\itemize{
\item \code{lat}: Altitude in degrees (-90 to +90)
\item \code{lon}: Azimuth in degrees (0-360, clockwise from north)
\item \code{dist}: Distance in AU
\item \code{status}: Status code (0 = success)
}

A list with components:
\describe{
\item{lat}{Altitude angle in degrees (corrected for refraction if requested)}
\item{lon}{Azimuth in degrees clockwise from north}
\item{dist}{Distance in AU}
\item{status}{Status code (0 = success)}
}
}
\description{
Given a horizontal Cartesian vector, returns horizontal azimuth and altitude.

Given a horizontal Cartesian vector, returns horizontal azimuth and altitude.
}
\details{
\strong{IMPORTANT:} This function differs from \code{astro_sphere_from_vector} in two ways:
\enumerate{
\item The longitude value represents azimuth defined clockwise from north
(e.g., east = +90), preserving traditional navigational conventions.
\item This function optionally corrects for atmospheric refraction.
}

The returned structure contains the azimuth in the \code{lon} field, measured in
degrees clockwise from north: east = +90 degrees, west = +270 degrees.

\strong{IMPORTANT:} This function differs from \code{\link[=astro_sphere_from_vector]{astro_sphere_from_vector()}} in two ways:
\itemize{
\item \code{\link[=astro_sphere_from_vector]{astro_sphere_from_vector()}} returns a \code{lon} value that represents azimuth defined
counterclockwise from north (e.g., west = +90), but this function represents a
clockwise rotation (e.g., east = +90). The difference is because
\code{\link[=astro_sphere_from_vector]{astro_sphere_from_vector()}} is intended to preserve the vector "right-hand rule",
while this function defines azimuth in a more traditional way as used in
navigation and cartography.
\item This function optionally corrects for atmospheric refraction, while
\code{\link[=astro_sphere_from_vector]{astro_sphere_from_vector()}} does not.
}

The returned structure contains the azimuth in \code{lon}.
It is measured in degrees clockwise from north: east = +90 degrees, west = +270 degrees.

The altitude is stored in \code{lat}.

The distance to the observed object is stored in \code{dist}, and is expressed in
astronomical units (AU).
}
\examples{
# Vector pointing east at 45° altitude
vec <- list(x = 0, y = -0.707, z = 0.707,
            t = as.POSIXct("2024-01-01", tz = "UTC"))
hor <- astro_horizon_from_vector(vec, refraction = 1)

# Convert horizontal vector to angular coordinates
vec <- list(x = 0, y = -1, z = 0, t = as.POSIXct("2024-01-01", tz = "UTC"))
hor <- astro_horizon_from_vector(vec, refraction = 1)
}
