% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_pair_longitude}
\alias{astro_pair_longitude}
\title{Ecliptic longitude of one body relative to another}
\usage{
astro_pair_longitude(body1, body2, time)
}
\arguments{
\item{body1}{First body (e.g., \code{astro_body["SUN"]}).}

\item{body2}{Second body (e.g., \code{astro_body["MOON"]})}

\item{time}{A POSIXct time value.}
}
\value{
A list with element:
\describe{
\item{angle}{Ecliptic longitude difference in degrees [0, 360).}
}
}
\description{
Determines where one body appears around the ecliptic plane as seen from Earth,
relative to another body's apparent position.
}
\details{
The returned angle is in the range [0, 360) degrees. The angle is 0 when the two bodies
are at the same ecliptic longitude. The angle increases in the prograde direction
(the direction planets orbit the Sun). When the angle is 180 degrees, the bodies
appear on opposite sides of the sky.

Neither \code{body1} nor \code{body2} may be the Earth.
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_pair_longitude(astro_body["SUN"], astro_body["MOON"], time)
}
