% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotate_vector}
\alias{astro_rotate_vector}
\title{Apply a rotation to a vector}
\usage{
astro_rotate_vector(rotation, vector)
}
\arguments{
\item{rotation}{A rotation matrix that specifies how the orientation of the vector
is to be changed}

\item{vector}{The vector whose orientation is to be changed. A list with components:
\describe{
\item{x}{The Cartesian x-coordinate in AU}
\item{y}{The Cartesian y-coordinate in AU}
\item{z}{The Cartesian z-coordinate in AU}
\item{t}{The date and time (POSIXct) at which this vector is valid}
}}
}
\value{
A vector in the orientation specified by \code{rotation}
}
\description{
This function transforms a vector in one orientation to a vector
in another orientation.
}
\examples{
# Create a vector and rotate it
vec <- list(x = 1, y = 0, z = 0, t = as.POSIXct("2024-01-01", tz = "UTC"))
rot <- astro_identity_matrix()
rotated <- astro_rotate_vector(rot, vec)
}
