% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsis.R
\name{search_planet_apsis}
\alias{search_planet_apsis}
\title{Search for the next planetary apsis}
\usage{
search_planet_apsis(body, start_time)
}
\arguments{
\item{body}{Integer constant identifying the planet. Use \code{astro_body["PLANET_NAME"]}
where \code{PLANET_NAME} is one of: \code{"MERCURY"}, \code{"VENUS"}, \code{"EARTH"}, \code{"MARS"},
\code{"JUPITER"}, \code{"SATURN"}, \code{"URANUS"}, \code{"NEPTUNE"}, or \code{"PLUTO"}.
Not allowed to be \code{"SUN"} or \code{"MOON"}.}

\item{start_time}{A \code{POSIXct} value indicating the date and time at which to
start searching for the next perihelion or aphelion.}
}
\value{
A list containing:
\describe{
\item{kind}{An integer flag: 0 for perihelion, 1 for aphelion.}
\item{time}{A \code{POSIXct} value representing the date and time of the
next planetary apsis.}
\item{dist_au}{The distance from the planet to the Sun in astronomical units.}
\item{dist_km}{The distance from the planet to the Sun in kilometers.}
}
}
\description{
Finds the date and time of a planet's perihelion (closest approach to the Sun)
or aphelion (farthest distance from the Sun) after a given time.
}
\details{
The closest point is called perihelion and the farthest point is called aphelion.
To iterate through consecutive alternating perihelion and aphelion events,
call \code{search_planet_apsis()} once, then use the return value to call
\code{next_planet_apsis()}. After that, keep feeding the previous return value
into another call of \code{next_planet_apsis()} as many times as desired.
}
\examples{
# Find the next perihelion/aphelion of Mars after 2025-01-01
start <- as.POSIXct("2025-01-01", tz = "UTC")
apsis <- search_planet_apsis(astro_body["MARS"], start)
apsis
}
\seealso{
\code{\link[=next_planet_apsis]{next_planet_apsis()}}
}
