% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestharp.R
\name{only_actual_args_differ}
\alias{only_actual_args_differ}
\title{Checks if two expressions differ only in terms of actual arguments}
\usage{
only_actual_args_differ(th1, th2)
}
\arguments{
\item{th1}{A TreeHarp object.}

\item{th2}{A TreeHarp object.}
}
\value{
Either 1 or 0. 1 means that the two expressions differ only in their 
actual arguments.
}
\description{
Checks if two expressions differ only in terms of actual arguments
}
\details{
From the node types, only calls and formal arguments are retained.
If these are identical, then a 1 is returned. Otherwise 0 is returned.
}
\examples{
ex1 <- TreeHarp(quote(X <- rnorm(10, mean=0.9, sd=4)), TRUE)
ex2 <- TreeHarp(quote(Y <- rnorm(20, mean=9, sd=4)), TRUE)
only_actual_args_differ(ex1, ex2)
}
