% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_avseqmc_progress.R
\name{init_avseqmc_progress}
\alias{init_avseqmc_progress}
\title{Initialize an \code{avseqmc_progress} Object}
\usage{
init_avseqmc_progress(sample_G, epsilon, ptilde = NULL, n = 0, S = 0)
}
\arguments{
\item{sample_G}{A function (without arguments) that draws one (or a batch of)
zero/one samples from the distribution G as in Equation (5), where the
function returns a vector of zeroes and ones.}

\item{epsilon}{The desired risk of overestimated significance.}

\item{ptilde}{Optional: a previously computed anytime-valid p-value estimate
(via the construction in Definition 6, based on Robbins (1970)). If
supplied, \code{n} must also be provided. The number of previously observed ones
observed from the Monte-Carlo sampler \code{sample_G} (\code{S}) is inferred from
\code{ptilde} and \code{n} unless given explicitly. If \code{ptilde} is rounded, supplying
\code{S} is recommended to avoid numerical inaccuracies in inferring it.}

\item{n}{Optional: The number of Monte-Carlo samples used to compute the
supplied \code{ptilde}. Must be given if \code{ptilde} or \code{S} is provided.}

\item{S}{Optional: The number of ones observed from \code{sample_G}. Must be given
when \code{n} is supplied. Can be used instead of inferring it from \code{ptilde} and
\code{n}.}
}
\value{
An object of class \code{avseqmc_progress} containing the progress of the
sequentially estimated p-value. The object is a list containing the
following elements:
\itemize{
\item \verb{$epsilon}: risk of overestimated significance used in the sequential estimation.
\item \verb{$sample_G}: function that samples (batches) from the Monte-Carlo distribution $G^*(X)$ as in Equation (5).
\item \verb{$ptilde}: sequence of sequential $p$-value estimates. The final value in this sequence is the most recent estimate of the $p$-value.
\item \verb{$Ltilde}: sequence of lower bounds of the confidence sequence based on the construction by Robbins (1970). Contains NA values if these were
not computed by default through \code{stopcrit =  list("type"="futility","param"=...)} or requested using
\code{compute_lower=TRUE}.
\item \verb{$n}: total number of samples drawn from the MC sampler.
\item \verb{$S}: total number of ones observed from the MC sampler.
\item \verb{$B}: sequence of number of ones observed at each sampling timepoint (which can be greater than 1 if \code{sample_G} samples in batches)
\item \verb{$Bn}: sequence of number of samples drawn from MC sampler at each timepoint (which can be greater than 1 if \code{sample_G} samples in batches)
}

If \code{ptilde}, \code{n}, and \code{S} are all empty, the object is initialized but empty
and can be used as a starting point for sequential estimation.
}
\description{
Initialize an object of class \code{avseqmc_progress}. This object
contains the progress of an earlier sequentially anytime-valid estimated
p-value from a Monte-Carlo simulation as described in Stoepker and Castro
(2024, Definition 6). Subsequent references to equations and sections in
this section of the reference manual pertain to this paper.

The object can be passed to \code{avseqmc()} to resume sampling.
}
\examples{
# Minimal example to construct an object based on earlier values of n and S
G1 <- function(){runif(1) < 0.04}
R1 <- init_avseqmc_progress(sample_G = G1,
                            epsilon = 0.001,
                            n = 1000,
                            S = 44)

}
\references{
Stoepker, I. V., and R. M. Castro. 2024. Inference with Sequential
Monte-Carlo Computation of p-Values: Fast and Valid Approaches.
https://doi.org/10.48550/arXiv.2409.18908.

Robbins, H. (1970). Statistical Methods Related to the Law of the Iterated
Logarithm. The Annals of Mathematical Statistics, 41(5):1397–1409.
http://dx.doi.org/10.1214/aoms/1177696786
}
\seealso{
\code{\link{avseqmc}} which can be used to resume the anytime-valid
sampling as logged in the constructed object.
}
