% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{getObservations}
\alias{getObservations}
\title{Get Observations Falling into Each Node}
\usage{
getObservations(data, treeData)
}
\arguments{
\item{data}{A data frame used to build BART model.}

\item{treeData}{A data frame representing the tree structure, including the
necessary columns `iteration`, `treeNum`, `var`, and `splitValue`.}
}
\value{
A modified version of `treeData` that includes two new columns: `obsNode` and
        `noObs`. `obsNode` lists the observations falling into each node, and
        `noObs` provides the count of observations for each node.
}
\description{
This function determines which observations from a given dataset fall into
which nodes of a tree, based on a tree structure defined in `treeData`.
The treeData object must include `iteration`, `treeNum`, `var`, and `splitValue` columns.
}
\examples{
data("tree_data_example")
# Create Terminal Column
tree_data_example <- transform(tree_data_example,
                              terminal = ifelse(is.na(var),
                              TRUE,
                               FALSE))
# Create Split Value Column
tree_data_example <- transform(tree_data_example,
                               splitValue = ifelse(terminal == FALSE,
                               value,
                               NA_integer_))
# get the observations
getObservations(data = input_data, treeData = tree_data_example)

}
