% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdplyr.R
\name{bd_collect}
\alias{bd_collect}
\title{Collects the results of a remote table called via \code{bdplyr()}}
\usage{
bd_collect(
  .lazy_tbl,
  billing_project_id = basedosdados::get_billing_id(),
  show_query = FALSE
)
}
\arguments{
\item{.lazy_tbl}{A variable that contains a database that was previously
connected through the \code{\link[=bdplyr]{bdplyr()}} function. Tipically, it will be called
after performing the desired operations with the \code{{dplyr}} verbs.}

\item{billing_project_id}{a string containing your billing project id.
If you've run \code{\link[=set_billing_id]{set_billing_id()}} then feel free to leave this empty.}

\item{show_query}{If TRUE will show the SQL query calling \code{\link[dplyr:explain]{dplyr::show_query()}}.
Is useful for diagnosing performance problems.}
}
\value{
A tibble.
}
\description{
After \code{\link[=bdplyr]{bdplyr()}} is used to create the remote connection, this function
allows you to collect the result of the manipulations carried out with
the \{dplyr\}'s verbs and thus use it in local memory completely.

Alternatively, you can also save to disk directly using \code{\link[=bd_write]{bd_write()}}
function or its derivatives: \code{\link[=bd_write_csv]{bd_write_csv()}} or \code{\link[=bd_write_rds]{bd_write_rds()}}.
}
\examples{
\dontrun{

# setup billing
 basedosdados::set_billing_id("billing-project-id")

 # select a cool database at Base dos Dados
bd_table <- basedosdados::bdplyr(
  "basedosdados.br_sp_gov_ssp.ocorrencias_registradas")

# quick look
bd_table \%>\%
  dplyr::glimpse()

 # filter, select and group the remote data
bd_ssp <-  bd_table \%>\%
  dplyr::filter(ano >= 2019) \%>\%
  dplyr::select(ano, mes, homicidio_doloso) \%>\%
  dplyr::group_by(ano, mes)

 # make some plots
library(ggplot2)

bd_ssp \%>\%
 # collect the data to continue the analisis
 basedosdados::bd_collect() \%>\%
  dplyr::summarise(homicidios_sum = sum(homicidio_doloso,
                                         na.rm = TRUE)) \%>\%
  ggplot(aes(x = mes, y = homicidios_sum, fill = ano)) +
  geom_col(position = "dodge")


}
}
