% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_reporting_structure.R
\name{apply_reporting_structures}
\alias{apply_reporting_structures}
\title{Apply reporting structures to generate retrospective reporting triangles}
\usage{
apply_reporting_structures(
  truncated_reporting_triangles,
  structure = 1,
  validate = TRUE
)
}
\arguments{
\item{truncated_reporting_triangles}{List of \code{n} truncated reporting triangle
matrices with as many rows as available given the truncation.}

\item{structure}{Integer or vector specifying the reporting structure.
If integer, divides columns evenly by that integer (with last possibly
truncated).  If vector, the sum must not be greater than or equal to the
number of columns. Default is 1 (standard triangular structure).}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
\code{reporting_triangles} List of retrospective reporting triangles,
generated by removing the bottom right observations from the truncated
reporting triangle matrices.
}
\description{
This function applies a reporting structure to a list of truncated reporting
triangles by setting observations to NA row by row from the bottom up based
on the specified structure. This generates the reporting triangles that
would have been available at each retrospective time point. It operates on
each element in the list in order (from most recent retrospective nowcast
time to oldest retrospective nowcast time).
}
\examples{
# Generate retrospective triangles from truncated triangles
trunc_rts <- truncate_to_rows(example_reporting_triangle, n = 2)
retro_rts <- apply_reporting_structures(trunc_rts)

# With custom structure
retro_rts_custom <- apply_reporting_structures(
  trunc_rts,
  structure = 2
)
retro_rts_custom
}
\seealso{
Retrospective data generation functions
\code{\link{apply_reporting_structure}()},
\code{\link{truncate_to_row}()},
\code{\link{truncate_to_rows}()}
}
\concept{generate_retrospective_data}
