% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{germany_covid19_hosp}
\alias{germany_covid19_hosp}
\title{Incident COVID-19 hospitalisations indexed by the date of positive test
(reference date) and report date from Germany in 2021 and 2022.}
\format{
A data.frame with 140,630 rows and 6 columns.
\describe{
\item{reference_date}{Date of first positive COVID-19 test formatted
in ISO8601 standards as YYYY-MM-DD.}
\item{location}{Character string indicating the location of the case
counts}
\item{age_group}{Character string indicating the age group of the case
counts.}
\item{delay}{Integer specifying the delay, in days, between the reference
date and the report date}
\item{count}{Integer indicating the number of cases indexed by reference
and report date.}
\item{report_date}{Date of case report, formatted in ISO8601 standards as
YYYY-MM-DD.}
}
}
\source{
This data comes directly from the preprocessed data in the
German COVID-19 Nowcast Hub from \url{https://github.com/KITmetricslab/hospitalization-nowcast-hub/blob/main/data-truth/COVID-19/COVID-19_hospitalizations_preprocessed.csv}. #nolint
It contains incident case counts by age group in Germany.
}
\usage{
germany_covid19_hosp
}
\description{
Incident COVID-19 hospitalisations indexed by the date of positive test
(reference date) and report date from Germany in 2021 and 2022.
}
\seealso{
Example datasets
\code{\link{example_downward_corr_rt}},
\code{\link{example_reporting_triangle}},
\code{\link{syn_nssp_df}},
\code{\link{syn_nssp_line_list}}
}
\concept{example_data}
\keyword{datasets}
