% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate_to_row}
\alias{truncate_to_row}
\title{Truncate reporting triangle by removing a specified number of the last rows}
\usage{
truncate_to_row(reporting_triangle, t, validate = TRUE)
}
\arguments{
\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{t}{Integer indicating the number of timepoints to truncate off the
bottom of the original reporting triangle.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
\code{trunc_rep_tri} A \code{reporting_triangle} object with \code{t} fewer rows
than the input. The class and metadata are preserved with updated reference
dates.
}
\description{
Removes the last \code{t} rows from a reporting triangle to simulate what would
have been observed at an earlier reference time.
}
\examples{
# Generate single truncated triangle
trunc_rep_tri <- truncate_to_row(example_reporting_triangle, t = 1)
trunc_rep_tri
}
\seealso{
Retrospective data generation functions
\code{\link{apply_reporting_structure}()},
\code{\link{apply_reporting_structures}()},
\code{\link{truncate_to_rows}()}
}
\concept{generate_retrospective_data}
