% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_design.R
\name{opt_design}
\alias{opt_design}
\title{Optimize a Basket Trial Design}
\usage{
opt_design(
  design,
  n,
  alpha,
  design_params = list(),
  scenarios,
  prec_digits,
  iter = 1000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{alpha}{The one-sided significance level.}

\item{design_params}{A list of params that is specific to the class of
\code{design}.}

\item{scenarios}{A matrix of scenarios.}

\item{prec_digits}{Number of decimal places that are considered when
adjusting lambda.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A list of data matrices generated with \code{get_data}. The
list elements have to correspond to the columsn of \code{scenarios}.}

\item{...}{Further arguments.}
}
\value{
A matrix with the expected number of correct decisions.
}
\description{
Optimize a Basket Trial Design
}
\examples{
design <- setup_fujikawa(k = 3, p0 = 0.2)
scenarios <- get_scenarios(design, p1 = 0.5)

## Equal sample sizes
# Without simulated data
\donttest{
opt_design(design, n = 20, alpha = 0.05, design_params =
           list(epsilon = c(1, 2), tau = c(0, 0.5)), scenarios = scenarios,
           prec_digits = 3)
}

# With simulated data
scenario_list <- as.list(data.frame(scenarios))
data_list <- lapply(scenario_list,
  function(x) get_data(k = 3, n = 20, p = x, iter = 1000))
\donttest{
opt_design(design, n = 20, alpha = 0.05, design_params =
           list(epsilon = c(1, 2), tau = c(0, 0.5)), scenarios = scenarios,
           prec_digits = 3, data = data_list)


## Unequal sample sizes
# Without simulated data
opt_design(design, n = c(15, 20, 25), alpha = 0.05, design_params =
           list(epsilon = c(1, 2), tau = c(0, 0.5)), scenarios = scenarios,
           prec_digits = 3)

# With simulated data
scenario_list <- as.list(data.frame(scenarios))
data_list <- lapply(scenario_list,
                    function(x) get_data(k = 3, n = c(15, 20, 25),
                                         p = x, iter = 1000))
opt_design(design, n = c(15, 20, 25), alpha = 0.05, design_params =
           list(epsilon = c(1, 2), tau = c(0, 0.5)), scenarios = scenarios,
           prec_digits = 3, data = data_list)
}
}
