% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcfrailph.R
\name{bcfrailph}
\alias{bcfrailph}
\title{Semi-parametric bivariate correlated frailty model.}
\usage{
bcfrailph(
  formula,
  data,
  initfrailp = NULL,
  frailty = c("gamma", "lognormal"),
  weights = NULL,
  control = bcfrailph.control(),
  ...
)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the Surv function.}

\item{data}{A dataframe contain survival time, censor, covariate etc with data in columns.}

\item{initfrailp}{Initial estimates for the frailty parameters. If not specified, initial frailty variance will be obtained from coxph with univariate frailty model and for correlation c(0.5) will be used.}

\item{frailty}{A type of frailty distribution to be used in fit. Either gamma or lognormal. The default is gamma.}

\item{weights}{vector of case weights for gamma model. the default is NULL.}

\item{control}{Arguments to control bcfrailph fit. The default is \code{\link{bcfrailph.control}}.}

\item{...}{further arguments}
}
\value{
An object of  that contains  the following components.
\itemize{
  \item \code{coefficients} - A vector of estimated Covariate coefficients.
  \item \code{frailparest} - A vector of estimated Frailty parameters i.e. frailty variance and correlation.
  \item \code{stderr}-A vector containing the Standard error of the Estimated parameters both covariate coefficients and  frailty parameters.
  \item \code{loglilk0}- Log likelihood of without frailty model or loglik of coxph fit.
  \item \code{loglilk}-Log likelihood of Cox PH model with frailty.
  \item \code{Iloglilk}- Log likelihood of with frailty. For gamma fit it is I-likelihood or the likelihood after integrating out the frailty term.For lognormal fit it is the approximate likelihood.
  \item \code{bhaz}- an array containing unique event times and estimated baseline hazard.
  \item \code{X}-Matrix of observed covariates.
  \item \code{time}-the observed survival time.
  \item \code{censor}-censoring indicator.
  \item \code{resid}-the martingale residuals.
  \item \code{lin.prid}-the vector of linear predictors.
  \item \code{frail}-estimated Frailty values.
  \item \code{iteration}-Number of outer iterations.
  \item \code{e.time}-the vector of unique event times.
  \item \code{n.event}- the number of events at each of the unique event times.
  \item \code{convergence}-an indicator, 1 if converge and 0 otherwise.
  \item \code{history}-an array containing records of estimates and other information on each iterations.
  }
}
\description{
Fit a semiparametric Bivariate correlated frailty model with Proportional Hazard structure.
}
\note{
Parameters of Bivariate correlated gamma frailty model was estimated using a modified EM approach given in Kifle et al (2022).
Parameters of Bivariate correlated lognormal frailty model is based on the penalized partial likelihood approach by Rippatti and Palmgren (2000).
}
\examples{
set.seed(4)
simdata<-simbcfrail(psize=300, cenr= c(0.3),beta=c(2),frailty=c("gamma"),
frailpar=c(0.5,0.5),bhaz=c("weibull"),
bhazpar=list(shape =c(5), scale = c(0.1)),
covartype= c("B"),covarpar=list(fargs=c(1),sargs=c(0.5)))
dataa<-simdata$data

fitbcfrgam=bcfrailph(Surv(time,censor)~ X1+frailty(PID) ,data=dataa,frailty="gamma")
fitbcfrgam

\donttest{
# now for lognormal

set.seed(18)
simdata<-simbcfrail(psize=100, cenr= c(0.2),beta=c(1,-0.7,0.5),frailty=c("lognormal"),
frailpar=c(0.5,-0.25),bhaz=c("exponential"),
bhazpar=list(scale = c(0.1)),covartype= c("N","N","B"),
covarpar=list(fargs=c(0,0,1),sargs=c(1,1,0.5)),comncovar=2)
dataa<-simdata$data

#fit
fitbcfrlogn=bcfrailph(Surv(time,censor)~ X1+X2+X3+frailty(PID) ,data=dataa,frailty="lognormal")
fitbcfrlogn
# the output looks like
#   Call:
#   bcfrailph(formula = Surv(time, censor) ~ X1 + X2 + X3 + frailty(PID),
#   data = dataa, frailty = "lognormal")
#
#   n=  200 and number of events= 160
#
#   Regression Coefficients:
#   Estimate   StdErr z.value   p.value
#   X1  1.09987  0.12144  9.0568 < 2.2e-16 ***
#   X2 -0.64995  0.10467 -6.2093 5.322e-10 ***
#   X3  0.34151  0.19510  1.7504   0.08005 .
#   ---
#   Frailty Distribution:Bivariate Correlated  log-normal
#   Variance of random effect = 0.459363 ( 0.1728421 )
#   Correlation Estimate of random effects = -0.4974605 ( 0.3284767 )
#   Approximated Log likelihood with frailty = -696.001
#   Log likelihood without frailty= -697.4393

## one can set the initial parameter for the frailty parameters
fitbcfrailph=bcfrailph(Surv(time,censor)~ X1+frailty(PID),data=dataa,initfrailp = c(0.1,0.5),
frailty="lognormal")
fitbcfrailph

# Not run

#if covariates are not included
fitmoe=bcfrailph(Surv(time,censor)~0,data=dataa,frailty="lognormal")
fitmoe
fitmoe=bcfrailph(Surv(time,censor)~1,data=dataa)
fitmoe

# if control is not specified correctly.
# if one needs to change only max.iter to be 100,

fitmoe=bcfrailph(Surv(time,censor)~ X1+frailty(PID),data=dataa,control=c(max.iter=100))
fitmoe

#the correct way is
fitmoe=bcfrailph(Surv(time,censor)~ X1+frailty(PID),data=dataa,
control=bcfrailph.control(max.iter=100))
fitmoe

#if initial frailty parameters are in the boundary of parameter space
fitmoe=bcfrailph(Surv(time,censor)~ X1,data=dataa,initfrailp=c(0.2,1))
fitmoe
fitmoe=bcfrailph(Surv(time,censor)~ X1,data=dataa,initfrailp=c(0,0.1))
fitmoe

#if a frailty distribution other than gamma and lognormal are specified

fitmoe=bcfrailph(Surv(time,censor)~ X1,data=dataa,,frailty="exp")
fitmoe
# End Not run
}

}
\references{
Kifle YG, Chen DG, Haileyesus MT (2022). Multivariate Frailty Models using Survey Weights with Applications to Twins Infant Mortality in Ethiopia. Statistics and Its Interface,106(4), 1\-10.

Rippatti, S. and Palmgren, J (2000). Estimation of multivariate frailty models using penalized partial likelihood. Biometrics, 56: 1016-1022.
}
\seealso{
\code{\link{bcfrailph.control}},\code{\link{simbcfrail}}
}
